'==========================================================================
'
' NAME: ADAcctProvisioning.vbs	
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================
'This script contains methods for provisioning customers accounts
'witin a centrally managed web hostng environment

Public Function CreateCustomer(strCustomer)
	Dim oTmpContainer
	Dim oTmpCustomers
	
	Set oTmpCustomers = GetADHostingRoot()
	Set oTmpContainer = CreateOU(oTmpCustomers,strCustomer)
	Set CreateCustomer = oTmpContainer
	Set oTmpContainer = Nothing
	Set oTmpCustomers = Nothing

End Function

Public Function getDomain()
	Dim oRootDSE
	Dim strDomain
	Dim strNetBIOS
	' Bind to the root of the Domain
	Set oRootDSE = GetObject("LDAP://RootDSE")
	strDomain = oRootDSE.get("defaultNamingContext")
	strTemp = Split(strDomain,",")(0)
	strNetBIOS = Right(strTemp,Len(strTemp)-3)
	getDomain = strNetBIOS
	Set oRootDSE = nothing
End Function

Function GetADHostingRoot()
	Dim oRootDSE
	Dim oTmpHosting
	Dim oTmpCustomers
	On Error Resume Next
	' Bind to the root of the Domain
	Set oRootDSE = GetObject("LDAP://RootDSE")
	' Connect to the the Hosting root to verify it is present
	Set oTmpHosting = GetObject("LDAP://OU=Hosting, " & oRootDSE.get("defaultNamingContext"))
	If Not IsObject(oTmpHosting) Then
		WScript.Echo "Hosting OU not created.  Please run secureAD.vbs to create. Script Aborting."
		WScript.Quit 
	End If
	'Since the Hosting root exists, we need to check and see if the Customers ou exists
	Set oTmpCustomers = GetObject("LDAP://OU=Customers, OU=Hosting, " & oRootDSE.get("defaultNamingContext"))
	If Not IsObject(oTmpCustomers) Then
		'It doesn't exists so we will create it
		set oTmpCustomers = CreateOU(oTmpHosting,"Customers")
	End if
	Set GetADHostingRoot = oTmpCustomers
	Set oRootDSE = Nothing
	Set oTmpHosting=Nothing
	Set oTmpCustomers = Nothing

End Function


Function CreateOU(oOU,strOuName)
	Dim oTOU
	
	Set oTOU = oOU.Create("organizationalUnit", "ou=" & strOuName)
	oTOU.setInfo
	Set CreateOU = oTOU
	Set oTOU=Nothing
	
end Function

Function CreateAdObject(oLDAP,strType,strName,strSAM,strUPN,strPass)


	Dim oTmp
	'Create the object
	Set oTmp = oLDAP.Create(strType, "cn=" & strName)
	'Set the SamAccountName
	oTmp.SamAccountName = strSAM
	'if it is a user object set the password
	oTmp.SetInfo
	If strType= "user" Then
		oTmp.SetPassword strPass
		oTmp.AccountDisabled=False
		If strUPN <> "" then
			oTmp.UserPrincipalName = strUPN
		End if
		oTmp.SetInfo
	End If
	Set CreateAdObject = oTmp
	Set oTmp = Nothing

End Function

Function CreateValidSAM(strName)

	Dim strCleaned
	'Clean out the domain suffix
	strCleaned = Split(strName,".")(0)
	'Replace any '@' with '_'
	strCleaned = Replace(strCleaned,"@","_")
	'Trim t 20 characters
	strCleaned = Left(strCleaned,20)
	'Pass it back
	CreateValidSAM = strCleaned
	

End Function

Function RandomPassword(intNumChars)
	Dim strPWD
	Dim strRandChars
	Dim intULim
	Dim intLLim
	Dim intSelectChar
	Dim I
	strPWD = ""
	strRandChars = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789!@#$%^&"
	intULim = Len(strRandChars)
	intLLim = 1
	Randomize
	For I = 1 To intNumChars
	     intSelectChar = Int((intULim - intLLim + 1) * Rnd + intLLim)
	     strPWD = strPWD & Mid(strRandChars,intSelectChar,1)
	Next
	RandomPassword = strPWD


End Function

Function AddToGroupAD (oGroup,oUser)
' **********************************************************
' Function AddToGroupAD (oGroup,oUser) 
' Description: Adds a user to a group in Active Driectory
' Details about the Functions used can be found at
' http://msdn.microsoft.com/library/default.asp?url=/library/en-us/adsi/adsi/iadsaccesscontrolentry_property_methods.asp
' 
' In:	oGroup	....	the Group Object the user will be added to.
'		oUser	....	the UserObject to be added to the group.
'		
' Out: 	AddToGroupAD	the result code for the operation
'						usually 0 if successfull or an
'						ADSI, LDAP or WIN32 Error.
' **********************************************************
	Dim varResult
	' Do a quick Sanity check if the user and the Group are in the same
	' OU otherwise do not add the user and return an error.
	If oGroup.Parent = oUser.Parent Then
		Write oLogFile," Adding user " & oUser.Name & " to group " & oGroup.Name, Err_INFO,bDebug
		oGroup.Add oUser.ADSPath
		' Commit Changes to AD
		oGroup.SetInfo
		varResult = Err.Number
	Else
		varResult = 99
	End If
	AddToGroupAD = varResult
End Function

Function SetUserPasswordProperties(bExpire,bChange,oUser)
Const ADS_UF_DONT_EXPIRE_PASSWD = &h10000
Const ADS_ACETYPE_ACCESS_DENIED_OBJECT = &H6
Const ADS_ACEFLAG_OBJECT_TYPE_PRESENT = &H1
Const ADS_RIGHT_DS_CONTROL_ACCESS = &H100
Const CHANGE_PASSWORD_GUID = "{ab721a53-1e2f-11d0-9819-00aa0040529b}"

Dim oSD
Dim oDACL
Dim oAce
Dim strTrustee
Dim arrTrustees
Dim intUAC

Set oSD   = oUser.Get("nTSecurityDescriptor")
Set oDACL = oSD.DiscretionaryAcl
arrTrustees = Array("nt authority\self", "everyone")
If bChange = True then
	'Enable user to change password (Admin Account) 
	For Each strTrustee In arrTrustees
	    For Each ace In oDACL
	        If(LCase(ace.Trustee) = strTrustee) Then
	            If((ace.AceType = ADS_ACETYPE_ACCESS_DENIED_OBJECT) And LCase(ace.ObjectType) = CHANGE_PASSWORD_GUID) Then
	                   oDACL.RemoveAce ace
	            End If
	        End If
	    Next
	Next
 
	oUser.Put "nTSecurityDescriptor", oSD
	oUser.SetInfo
	Write oLogFile, "Enabled " & oUser.name & " 'User can change password' property.",err_info,bDebug
Else 'User can't change password
	For Each strTrustee in arrTrustees
	    Set oACE = CreateObject("AccessControlEntry")
	    oACE.Trustee = strTrustee
	    oACE.AceFlags = 0
	    oACE.AceType = ADS_ACETYPE_ACCESS_DENIED_OBJECT
	    oACE.Flags = ADS_ACEFLAG_OBJECT_TYPE_PRESENT
	    oACE.ObjectType = CHANGE_PASSWORD_GUID
	    oACE.AccessMask = ADS_RIGHT_DS_CONTROL_ACCESS
	    oDACL.AddAce oAce
	Next
	 
	oSD.DiscretionaryAcl = oDACL
	oUser.Put "nTSecurityDescriptor", oSD
	oUser. SetInfo
	Write oLogFile, "Disabled " & oUser.name & " 'User can change password' property.",err_info,bDebug

End If


 'PAssword Expiration
If bExpire = True Then
	intUAC = oUser.Get("userAccountControl")
	 
	If ADS_UF_DONT_EXPIRE_PASSWD AND intUAC Then
	    
	Else
	    oUser.Put "userAccountControl", intUAC Xor ADS_UF_DONT_EXPIRE_PASSWD
	    oUser.SetInfo
	End If
	Write oLogFile,"Set 'Password never expires' for " & oUser.name,Err_INFO,bDebug
End If

SetUserPasswordProperties = 0


End Function

Function SetADSecurity(oOU,strAdminGroupName,strUserGroupName)
' **********************************************************
' Function SetADSecurity (oOU)
' Description: 	Setup the ACLs in Active Driectory for the new 
'				customer
' 
' In:	oOU	....		the OU Object the ACL will be modified on
'		
' Out: 	none
' **********************************************************
' Set Public Constants
Const SE_DACL_PROTECTED				= &H1000
Const SE_SACL_PROTECTED				= &H2000

	Set securityDescriptor = oOU.Get("ntSecurityDescriptor")
	Set oDACL = securityDescriptor.DiscretionaryAcl
	
	'Write "DACL before Editing", Err_Info
	'For Each a In oDACL
		'Write a.Trustee & " " & a.Flags, Err_INfo
	'Next
	
	Set oACE = CreateObject("AccessControlEntry")
	DeleteAce oDACL, "NT AUTHORITY\Authenticated Users"
	DeleteAce oDACL, strAdminGroupName
	'	Reset AllUsers
	DeleteAce oDACL, strUserGroupName
	
	' Allow Users from within this OU to view other members in the same Org
	' CHEAT Sheet: AddAce(TrusteeName, gAccessMask, gAceType, gAceFlags, gFlags, gObjectType, gInheritedObjectType)
	AddAce oDACL, strUserGroupName, 131092, 0, 2, 0, 0, 0
	
	'** Full Control of Organizational Units
	' Organizational Unit, (Full Control)
	AddAce oDACL, strAdminGroupName, 983551, 5, 10, 2, 0,"{BF967AA5-0DE6-11D0-A285-00AA003049E2}"
		

	' This object and all child objects, (Create User Objects, Delete User Objects)
	AddAce oDACL, strAdminGroupName, 3, 5, 2, 1, "{BF967ABA-0DE6-11D0-A285-00AA003049E2}", 0
	
	'** Full Control of User Objects
	' User Object, (Full Control)
	AddAce oDACL, strAdminGroupName, 983551, 5, 10, 2, 0, "{BF967ABA-0DE6-11D0-A285-00AA003049E2}"
	
	'** Reset User Passwords
	' User Objects, (Reset Password)
	AddAce oDACL, strAdminGroupName, 256, 5, 10, 3, "{00299570-246D-11D0-A768-00AA006E0529}", "{BF967ABA-0DE6-11D0-A285-00AA003049E2}"
	
	'** Create & Delete Groups
	' This object and all child objects, (Create Group Objects, Delete Group Objects)
	AddAce oDACL, strAdminGroupName, 3, 5, 2, 1, "{BF967A9C-0DE6-11D0-A285-00AA003049E2}", 0
	
	'** Full Control of Groups
	' Group Objects, (Full Control)
	AddAce oDACL, strAdminGroupName, 983551, 5, 10, 2, 0, "{BF967A9C-0DE6-11D0-A285-00AA003049E2}"
	
	'** Modify the Membership of Groups
	AddAce oDACL, strAdminGroupName, 48, 5, 10, 3, "{BF9679C0-0DE6-11D0-A285-00AA003049E2}", "{BF967A9C-0DE6-11D0-A285-00AA003049E2}"
	
	'** Create & Delete Organizational Units
	' This object and all child objects, (Create Organizational Unit, Delete Organizational Unit)
	AddAce oDACL, strAdminGroupName, 3, 5, 2, 1, "{BF967AA5-0DE6-11D0-A285-00AA003049E2}", 0
	
	
	'** Write Properties to the Root OU Object Only
	' This Object, (Write Properties)
	AddAce oDACL, strAdminGroupName, 32, 0, 0, 0, 0, 0
	'Set oDACL = ReorderACL(oDACL,FALSE)
	' Write "DACL after Editing", Err_Info
' 	For Each a In oDACL
' 		Write a.Trustee & " " & a.Flags, Err_INFO
' 	Next
	'** Add New Dacl to the Security Descriptor
	SecurityDescriptor.discretionaryAcl = oDACL
	oOU.put "ntSecurityDescriptor", securityDescriptor
	' Commit the changes to AD
	oOU.SetInfo
	SetADSecurity = 0
	
End Function

Function DeleteAce(oDACL, TrusteeName)
'*******************************************************************
' Function DeleteAce(oDACL, TrusteeName)
'
' Purpose: Deletes an ACE from an existing DACL
' Details about the Functions used can be found at
' http://msdn.microsoft.com/library/default.asp?url=/library/en-us/adsi/adsi/iadsaccesscontrolentry_property_methods.asp
' Input:   	oDACL						Access Control List (Object)
'				TrusteeName					Name of Trustee to add (String)
'				
' Output:  None
'*******************************************************************
		' iterate throught the ACE Collection 
		' to find the Ace we are looking for
		For Each oAce in odacl
			if (oAce.Trustee = TrusteeName) then
				Write oLogFile,"Found and Deleted: " & TrusteeName, Err_INFO,bDeug
				' Remove the ACE from the DACL
				oDACL.RemoveAce(oAce)
			Else
				Write oLogFile,TrusteeName & " not Found", Err_INFO,bDebug
			End if
		Next		
End Function


Function AddAce(oDACL, sTrusteeName, vAccessMask, vAceType, vAceFlags, vFlags, vObjectType, vInheritedObjectType)
'**************************************************************
' Function AddAce(oDACL, TrusteeName, vAccessMask, vAceType,_
'				 vAceFlags, vFlags, vObjectType, vInheritedObjectType)
'
' Purpose: Adds and ACE to an existing acl
' Details about the Functions used can be found at
' http://msdn.microsoft.com/library/default.asp?url=/library/en-us/adsi/adsi/iadsaccesscontrolentry_property_methods.asp
' Input:   	dacl						Access Control List (Object)
'				TrusteeName					Name of Trustee to add (String)
'				vAccessMask					AccessMask (String)
'				vAceType					AceType ()
'				vAceFlags					AceFlags ()
'				vFlags						Flags ()
'				vObjectType					ObjectType ()
'				vInheritedObjectType		InheritedObjectType ()
'				
' Output:  None
'*******************************************************************
	Dim oNewAce
	Write oLogFile,"Adding ACE for " & sTrusteeName, Err_Info,bDebug
	' Create the new ACE Object
	Set oNewAce = CreateObject("AccessControlEntry")
	' Put the Access Mask in
	oNewAce.AccessMask = vAccessMask
	' Set the ACE Type
	oNewAce.AceType = vAceType
	' Set the inheritance Flags
	oNewAce.AceFlags = vAceFlags
	' Set the Flags
	oNewAce.Flags = vFlags
	' Set the Trustee
	oNewAce.Trustee = sTrusteeName

		'Check to See if ObjectType needs to be set
		If cStr(vObjectType) <> "0" then
			oNewAce.ObjectType = vObjectType
		End If

		'Check to See if InheritedObjectType needs to be set
		If cStr(vInheritedObjectType) <> "0" then
			oNewAce.InheritedObjectType = vInheritedObjectType
		End If
	oDACL.AddAce oNewAce
	
	' Kill Objects
	Set oNewAce = Nothing
End Function

